# Развертывание приложения в on-prem K8s (Standalone)

## 1. Требования к рабочему месту
- Helm 3.12.0+
- Terraform 1.5.7
- Terragrunt 0.50.4
- SOPS 3.7.3
- Age 1.1.1

## 2. Git-repository
Подготовить 2 репозитория, примеры:
1. https://gitlab.vktech.tools/b2b/hr/devops/deployments/demo-onprem.git
```
  ├── ...
  └── env.yaml - в данном файле необходимо указать ваши значения
```
2. https://gitlab.vktech.tools/b2b/hr/devops/helm.git

## 3. Пример кластера Kubernetes (K8s) 1.26+
```
kubectl get nodes
NAME    STATUS   ROLES           AGE     VERSION
node1   Ready    control-plane   0m00s   v1.26.5
node2   Ready    <none>          0m00s   v1.26.5
node3   Ready    <none>          0m00s   v1.26.5
node4   Ready    <none>          0m00s   v1.26.5
node5   Ready    <none>          0m00s   v1.26.5  
```

## 4. Пример создания labels для worker nodes
т.к. в данном примере используем local-path-provisioner, необходимо указать labels для worker nodes 
```
kubectl label nodes node2 ingress-nginx-node=true
kubectl label nodes node3 kafka=true
kubectl label nodes node4 minio=true
kubectl label nodes node5 postgres=true
kubectl label nodes node5 clickhouse=true

kubectl label nodes node-4 redis=true

# Проверка labels
kubectl label --list nodes node2 | grep -i ingress-nginx-node
```
#### Пример редактирования labels
```
kubectl label --overwrite nodes node2 ingress-nginx-node=false
```
#### Пример удаления labels
```
kubectl label --overwrite nodes node2 ingress-nginx-node-
```

## 5. Ingress controller (опциональный шаг: если ingress-controller уже настроен, пропускаем)
#### Оригинальный манифест ingress-controller
```
wget https://raw.githubusercontent.com/kubernetes/ingress-nginx/controller-v1.8.2/deploy/static/provider/baremetal/deploy.yaml
```
##### Пример отредактированного манифеста находится здесь: `services/ingress-controller/values.yaml` для варианта NetworkHost

#### Установка ingress-controller
```
kubectl apply -f services/ingress-controller/values.yaml
```

## 6. Local Path Provisioner (PV provisioner support)
#### Оригинальный манифест local-path-provisioner
```
wget https://raw.githubusercontent.com/rancher/local-path-provisioner/master/deploy/local-path-storage.yaml
```
##### Пример отредактированного манифеста находится здесь: `services/local-path/values.yaml`

#### Установка local-path-provisioner
```
kubectl apply -f services/local-path/values.yaml
# Проверяем
kubectl -n local-path-storage get pod
kubectl get sc
```
### Используем указывая следующий storageClass в требуемых values.yaml
`storageClassName: local-path`

## 7. CloudNativePG (для развертывания PostgreSQL в K8s)
```
helm repo add cloudnative-pg https://cloudnative-pg.io/charts/

helm upgrade --install cnpg cloudnative-pg/cloudnative-pg --version 0.20.0 --create-namespace --namespace cnpg-system --wait
```

## 8. ArgoCD (для развертывания сервисов и приложения в K8s)
#### Добавление чарта
```
helm repo add argo https://argoproj.github.io/argo-helm
```
##### Пример отредактированного values.yaml находится здесь: `services/argocd/values.yaml`
#### Установка ArgoCD с использованием отредактированного values.yaml
```
helm upgrade --install argocd argo/argo-cd --version 5.52.1 --values services/argocd/values.yaml --create-namespace --namespace argocd --wait
```
#### Получение пароля admin
```
kubectl -n argocd get secret argocd-initial-admin-secret -o jsonpath="{.data.password}" | base64 -d
oIB-dARZJxq9eEJT
```

## 9. Создание проекта в ArgoCD
```
kubectl apply -f services/argocd/AppProject.yaml
```
#### Создание секрета для доступа к репо из ArgoCD
```
kubectl apply -f services/argocd/repocred.yaml
```
#### Создание секрета для доступа к реджистри
```
kubectl apply -f services/argocd/regcred.yaml
```

---
## 10. Создание аппсета для развертывания инфрастуктурных сервисов в K8s
```
kubectl apply -f services/argocd/servicesApplicationSet.yaml
```
---
### Действия после развертывания инфрастуктурных сервисов

#### необходимо установить расширения для следующих БД:
- filestorage 
- groups
- profile
```
CREATE EXTENSION pg_trgm; 
CREATE EXTENSION btree_gin;
```
#### Создать realm в KeyCloak
Для этого нужно перейти по адресу <your_domain>/auth, пройти аутентифкацию под пользователем admin, после чего:
1. Create realm;
2. Выбрать JSON файл services/keycloak/realm-export.json и нажать кнопку Create;
3. Создать локального пользователя с ролью superuser:
- выбрать realm: ph
- в меню перейти в раздел User, нажать кнопку Add user
- в форме создания пользователя заполнить обязательные поля и нажать кнопку Create
- перейти на вкладку Credentials и установить пароль
- перейти на вкладку Role mapping, нажать кнопку Assigne role
- выбрать в поле фильтра: Filter by clients
- отметить галочкой пункт: ph-master superuser
- нажать кнопку Assign

#### Актуализировать значение JWT переменной
- Скопировать JWT ключ из KeyCloak, для этого нужно перейти по адресу <your_domain>/auth, пройти аутентифкацию под пользователем admin, далее выбрать realm: ph, после чего ниже в разделе  меню Configure, выбрать пункт Realm settings, перейти на вкладку Keys и в строке RS256 нажать кнопку Public key, скопировать содержимое и вставить как значение переменной `keycloak.jwt_key` в файле `env.yaml`;

---
## 11. Создание аппсета приложения PeopleHub
```
kubectl apply -f services/argocd/appsApplicationSet.yaml
```
---
### Действия после развертывания приложения PeopleHub
После первого развертывания требуется выполнить следующие команды в контейнерах для указанных компонент приложения.

#### Создание суперпользователя для админпанели:

При создании суперпользователя используем данные из env.yaml

```bash
django:
    superuser_name: root
    superuser_pass: any_django_password
```

| Компонент                   | Команда                                 |
| --------------------------- | --------------------------------------- |
| **dictionaries-backend-***  | python manage.py createsuperuser        |
| **filestorage-backend-***   | python manage.py createsuperuser        |
| **notifications-backend-*** | python manage.py createsuperuser        |
| **pages-backend-***         | python manage.py createsuperuser        |
| **profile-backend-***       | python manage.py createsuperuser_custom |
| **roles-backend-***         | python create_admin_panel_user.py       |
| **settings-backend-***      | python create_admin_panel_user.py       |
| **blogs-backend-***         | python manage.py createsuperuser        |
| **calendar-backend-***      | python manage.py createsuperuser        |
| **cms-backend-***           | python create_admin_panel_user.py       |
| **comments-backend-***      | python create_admin_panel_user.py       |
| **events-backend-***        | python manage.py createsuperuser        |
| **gamification-backend-***  | python manage.py createsuperuser        |
| **groups-backend-***        | python manage.py createsuperuser        |
| **integrator-backend-***    | python manage.py createsuperuser        |
| **meetings-backend-***      | python manage.py createsuperuser        |
| **polls-backend-***         | python manage.py createsuperuser        |
| **tasks-backend-***         | python manage.py createsuperuser        |
| **termsofuse-backend-***    | python manage.py createsuperuser        |

#### Заполнение справочников (токен можно взять из браузера, после авторизации на портале, воспользовавшись инструментами разработчика):

| Компонент                  | Команда                                                      |      |
| -------------------------- | ------------------------------------------------------------ | ---- |
| **dictionaries-backend-*** | curl --location --request POST '{{host}}/api/discovery/init_dictionaries/' \ --header 'Authorization: Bearer <your_token>' |      |

####  Загрузить файлы для оргштатки:

| Компонент            | Команда                                                      |      |
| -------------------- | ------------------------------------------------------------ | ---- |
| **groups-backend-*** | curl --location --request POST '{{host}}/api/discovery/internal/upload_files/' \ --header 'Authorization: Bearer <your_token>' |      |

#### Создать/cинхронизировать благодарности и награды:

| Компонент                  | Команда                                                      |      |
| -------------------------- | ------------------------------------------------------------ | ---- |
| **gamification-backend-*** | python manage.py sync_thanks <br />python manage.py sync_badges |      |

#### Наполнение сервиса pages:

| Компонент           | Команда                              |      |
| ------------------- | ------------------------------------ | ---- |
| **pages-backend-*** | python manage.py create_default_data |      |

## 12. Проверить работоспособность приложения
