#!/bin/sh


INSTALLDIR="/var/CommuniGate"
CGIDIR="/var/CommuniGate/cgi"
CONFIG="/var/CommuniGate/mmindex.cfg"
PIDFILE="/var/run/mmindex.pid"

STARTUPDIR="/etc/init.d"

while [ "$1" != "" ]; do
  case $1 in
    --installdir )  shift
                    INSTALLDIR=$1
                    ;;
    --cgidir )      shift
                    CGIDIR=$1
                    ;;
    --config )      shift
                    CONFIG=$1
                    ;;
    --pidfile )     shift
                    PIDFILE=$1
                    ;;
    --startupdir )  shift
                    STARTUPDIR=$1
                    ;;
    -h | --help )
  echo "Usage: $0 [[--installdir dir] [--config file] [--pidfile file] [--startupdir dir]]"
  exit
  ;;
    * )
  echo "Usage: $0 [[--installdir dir] [--config file] [--pidfile file] [--startupdir dir]]"
  exit 1
  esac
  shift
done

more <<!EOF
#
# CommuniGate  This shell script installs MMIndex full-text search engine
#              for CommuniGate Pro communication server
#
# (c) 1998-2017 Stalker Software, Inc.
#
# mmindex will be installed into ${INSTALLDIR}
# mmsearch will be installed into ${CGIDIR}
# Configuration file is set to ${CONFIG}
# PID file is set to ${PIDFILE}
# Startup script will be installed into ${STARTUPDIR}
# 
# Values above can be changed using parameters:
#
# Usage: $0 [[--installdir dir] [--config file] [--pidfile file] [--startupdir dir]]
#
!EOF

echo -n "Continue? [Y] "
read answer 
if [ "N${answer}" != "N" ] && [ "${answer}" != "Y" ] && [ "${answer}" != "y" ]; then
  exit
fi

if [ ! -d ${INSTALLDIR} ] ; then
  echo "Creating installation directory..."
  if mkdir -p ${INSTALLDIR} ; then
    echo "${INSTALLDIR} created"
  else
    echo "Failed to create ${INSTALLDIR}" ; exit 1
  fi
fi
if [ ! -d ${CGIDIR} ] ; then
  echo "Creating cgi directory..."
  if mkdir -p ${CGIDIR} ; then
    echo "${CGIDIR} created"
  else
    echo "Failed to create ${CGIDIR}" ; exit 1
  fi
fi

echo "Copying mmindex..."
if cp -f mmindex ${INSTALLDIR}/ ; then
  echo "mmindex has been copied to ${INSTALLDIR}"
else
  echo "Failed to copy mmindex to ${INSTALLDIR}" ; exit 1
fi
echo "Copying mmsearch..."
if cp -f mmsearch ${CGIDIR}/ ; then
  echo "mmsearch has been copied to ${CGIDIR}"
else
  echo "Failed to copy mmsearch to ${CGIDIR}" ; exit 1
fi

echo "Installing configuration file..."
if touch ${CONFIG} ; then
cat >${CONFIG} <<!EOF
# server host name or ip address optionally with ximss tcp port number (11024 by default)
server=localhost
# credentials of user with sufficient access rights to read mail data
username=postmaster
password=qwerty
# directory to keep indexes, relative to account account location
indexdir=account.web/private/index
# cgpro base directory
basedir=/var/CommuniGate
# list of users for mail indexing
userlist=user1,user2@domain2.com,user3
# list of domains for mail indexing
domainlist=domain1.com,domain3.com
# log detailing level (0 <= loglevel <= 5)
loglevel=3
# indexing period in seconds
indexperiod=3600
!EOF
chmod 0600 ${CONFIG}
echo "Configuration file has been installed: ${CONFIG}"
else
  echo "Failed to install configuration file: ${CONFIG}" ; exit 1
fi

echo "Installing startup script..."
if [ -d ${STARTUPDIR} ] ; then
  if touch ${STARTUPDIR}/MMIndex ; then
cat >${STARTUPDIR}/MMIndex <<!EOF
#!/bin/sh
#
# chkconfig: 345 90 20
# description: Mail indexing daemon for CommuniGate Pro communication server
if [ -f /etc/rc.d/init.d/functions ]; then
  . /etc/rc.d/init.d/functions
elif [ -f /etc/init.d/functions ]; then
  . /etc/init.d/functions
fi

INSTALLDIR="${INSTALLDIR}"
CONFIG="${CONFIG}"
PIDFILE="${PIDFILE}"

case "\$1" in
start)
  if [ -f \${PIDFILE} ] ; then
    echo "MMIndex is already running"
  else
    echo -n "Starting MMIndex"
    if \${INSTALLDIR}/mmindex \${CONFIG} \${PIDFILE} ; then
      echo ". Started"
    else
      echo ". Failed"
    fi
  fi
  ;;
stop)
  if [ ! -f \${PIDFILE} ] ; then
    echo "MMIndex is not running"
  else
    echo -n "Shutting down MMIndex"
    if kill \`cat \${PIDFILE}\` ; then
      echo ". Stopped"
    else
      echo ". Failed"
    fi
  fi
  ;;
status)
  if [ ! -f \${PIDFILE} ] ; then
    echo "MMIndex is not running"
  else
    echo "MMIndex is running. pid=\`cat \${PIDFILE}\`"
  fi
  ;;
reload)
  if [ ! -f \${PIDFILE} ] ; then
    echo "MMIndex is not running"
  else
    echo -n "Realoading MMIndex configuration"
    if kill -s USR1 \`cat \${PIDFILE}\` ; then
      echo ". Reloaded"
    else
      echo ". Failed"
    fi
  fi
  ;;
reindex)
  if [ ! -f \${PIDFILE} ] ; then
    echo "MMIndex is not running"
  else
    echo -n "Starting MMIndex reindexing"
    if kill -s USR2 \`cat \${PIDFILE}\` ; then
      echo ". Started"
    else
      echo ". Failed"
    fi
  fi
  ;;
*)
  echo "Usage: \$0 [ start | stop | status | reload | reindex ]"
  exit 1
  ;;
esac
!EOF
chmod 0775 ${STARTUPDIR}/MMIndex
echo "Startup script has been installed: ${STARTUPDIR}/MMIndex"
else
  echo "Failed to install startup script: ${STARTUPDIR}/MMIndex" ; exit 1
fi
else
  echo "Failed to access startup script directory: ${STARTUPDIR}" ; exit 1
fi

sync

echo "MMIndex has been installed"
