#!/usr/bin/perl -w
use strict;
use Socket;
use CLI; 

use sigtrap;
use Time::HiRes qw ( time sleep );
use POSIX qw(:sys_wait_h);

my $logFileName="log.txt";
my ($CGServerAddress,$CGServerWebmailPort,$CGServerCLIPort)=('localhost',8100,106);

my ($CGServerLogin,$CGServerPassword);
my ($domainName,$nUsers,$UsersBase,$scenarioFile);
my @theScenario;
my $debug=1;
my $debugVerbose=0;

my $sessionID;
my $socket;
my $userID;
my ($httpRetCode,$httpRetText,%httpHeader,@httpBody);


readConfigFile();
readScenarioFile();

my ($data,$errCode);

unlink($logFileName);
print "Creating test accounts...\n";

$errCode=createAccounts();


print "Launching $nUsers user processes...\n";

my $countChildren=$nUsers;

my $t0=Time::HiRes::time();

for(my $idx=1;$idx<=$nUsers;$idx++) {
  $userID=$idx;
  my $pid=fork();
  if(defined $pid) {
    unless($pid) { # child
      stressUser();
      exit(0);
    } else {
      #print "pid=$pid\n" 
    }
  } else {
    print "idx=$idx fork() failed: $!\n";
  }
}

print "Waiting for children processes...\n";
while(wait()!=-1) {};

  my $t1=Time::HiRes::time();
  printf("\nElapsed time: %.3f s.\n",$t1-$t0);

exit(0);

sub stressUser {
  my $accountName=sprintf("%s%04d",$UsersBase,$userID);
  $accountName.='@'.$domainName;
  my $lineCnt=0;
  foreach(@theScenario) {
    my $line=$_; $lineCnt++;
    myLog("($userID) Line: $line\n") if($debug);
    next if(/^\s*$/);
    next if(/^#/);
    if(/^login/i) {
      webmailLogin($accountName,'abc');
    } elsif(/^logout/i) {
      webmailGetPage("bye.wssp");

    } elsif(/^pause\s+(\+?\d+)/i) {
      my $delay=$1;
      if($delay=~/^\+(\d+)/) {
        $delay=int(rand($1+1));
      }
      sleep($delay);   

    } elsif(/^GetPage\s+(.*)/i) {
      my $url=$1;
      webmailGetPage($url);

    } elsif(/^submitMessage\s+(.*)/i) {
      my $size=$1;
      my $address=sprintf("%s%04d",$UsersBase,1+int(rand($nUsers)));
      $address.='@'.$domainName;
      submitMessage($address,"Test message of $size Kb",$size);

    } elsif(/^openMailbox\s+(.*)/i) {
      webmailOpenMailbox($1);
    } elsif(/^readMailbox\s+(.*)/i) {
      webmailReadMailbox($1);
     
    }else{
      die "($userID) Line $lineCnt Syntax error: $line\n";
    }
  }
  exit(0);

}






sub readConfigFile {
  my $cfgFileName='webStressTest.cfg';
 
  open(FILE,$cfgFileName) || die "Can't open $cfgFileName: $!";
  while(<FILE>) {
    next if(/^#/);
    $CGServerAddress=$1 if(/hostname\s+(.*)/i);
    $CGServerWebmailPort=$1 if(/webmailport\s+(.*)/i);
    $CGServerCLIPort=$1 if(/cliport\s+(.*)/i);
    $CGServerLogin=$1 if(/adminLogin\s+(.*)/i);
    $CGServerPassword=$1 if(/adminPAssword\s+(.*)/i);
  
    $domainName=$1 if(/TestDomain\s+(.*)/i);
    $nUsers=$1 if(/NUsers\s+(.*)/i);
    $UsersBase=$1 if(/UserNamesBase\s+(.*)/i);
    $scenarioFile=$1 if(/ScenarioFile\s+(.*)/i);
    
  }
  close(FILE);
  
  die "Hostname is not defined in $cfgFileName\n" unless($CGServerAddress);
  die "AdminLogin is not defined in $cfgFileName\n" unless($CGServerLogin);
  die "AdminPassword is not defined in $cfgFileName\n" unless($CGServerPassword);
  
  die "TestDomain is not defined in $cfgFileName\n" unless($domainName);
  die "NUsers is not defined in $cfgFileName\n" unless($nUsers);
  die "UsersBase is not defined in $cfgFileName\n" unless($UsersBase);
  die "ScenarioFile is not defined in $cfgFileName\n" unless($scenarioFile);
  
  #print "a=$CGServerAddress, l=$CGServerLogin p=$CGServerPassword\n";
  #print "a=$domainName, l=$nUsers p=$scenarioFile\n";

}

sub readScenarioFile {
  open(FILE,$scenarioFile) || die "Can't open $scenarioFile: $!";
  while(<FILE>) {
    chomp;
    push(@theScenario,$_);
  }
  close(FILE);
}


sub createAccounts {
  my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => $CGServerCLIPort,
                          login    => $CGServerLogin,
                          password => $CGServerPassword } )
   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";

  
  my $data=$cli->Route("LoginPage\@$domainName");
  unless($data && ($data->[0] eq 'LOCAL')) {
    unless($cli->CreateDomain($domainName)) {
      my $msg="Can't create domain $domainName: ".$cli->GetErrMessage();
      $cli->Logout();
      return $msg;
    }
    myLog("Domain $domainName created.");  
  }

  for(my $idx=1;$idx<=$nUsers;$idx++) {
    my $accountName=sprintf("%s%04d",$UsersBase,$idx);
    $accountName.='@'.$domainName;
    $data=$cli->Route($accountName);
    unless($data && ($data->[0] eq 'LOCAL')) {
      unless($cli->CreateAccount(accountName => $accountName,settings => {Password=>"abc"})) {
        my $msg="Can't create account $accountName: ".$cli->GetErrMessage();
        $cli->Logout();
        return $msg;
      }
      myLog("Account $accountName created.");  
    } else {
      myLog("Account $accountName already exists.");  
    }
   
  }
  $cli->Logout();
  undef;
}


#-----------------------

sub sendCommand {
  my ($command)=@_;
  #myLog("($userID)> $command") if($debug);
  send($socket,$command,0);
}
    

    
sub readLine {
  my ($lim)=@_;
  $lim=1000000 unless(defined($lim));
  my $ln='';
  for(;$lim>0;$lim--) {
    my $ch;
    recv($socket,$ch,1,0);
    $ln.=$ch;
    last if($ch eq "\012");
  }
  return $ln;
}


sub httpConnect {
  my $iaddr   = inet_aton($CGServerAddress);
  unless($iaddr) {
    die "no host: $CGServerAddress";
  }  
  my $paddr   = sockaddr_in($CGServerWebmailPort, $iaddr);

  my $proto   = getprotobyname('tcp');
  unless(socket($socket, PF_INET, SOCK_STREAM, $proto)) {
    die "socket error: $!";
  }  
  unless(connect($socket, $paddr)) {
    die "connect error: $!";
  }

}


#-----------------------
sub myLog {
  my ($data)=@_;
  $data=~s/\012//g;
	unless (open LOG,">>$logFileName") {
		print "* can't append to $logFileName: $!\n";
		return;
	}

	print LOG "$data\n";
	close LOG;
}

sub httpReadResponse {
  shutdown($socket, 1); #done writing
  $httpRetText=readLine();
  $httpRetText=~s/[\015\012]//g;
  $httpRetText=~/(\d\d\d)/;
  $httpRetCode=$1;
  myLog("($userID)<$httpRetText\n") if($debug);
  
  %httpHeader=();
  @httpBody=();
  my $line;

  while($line=readLine()) {
    $line=~s/[\015\012]//g;
    last if($line eq '');
    myLog("($userID)<$line") if($debug);
    $line=~/^(.*?): (.*)/;
    my ($key,$value)=($1,$2);
    $httpHeader{$key}=$value;
  }
#    foreach(keys %httpHeader) {
#      print "<$_>=$httpHeader{$_}\n";
#    }

  my $len=$httpHeader{'Content-Length'} || 0;

  while($len>0) {
    $line=readLine($len);
    $len-=length($line);
    $line=~s/[\n\r]//g;
    push(@httpBody,$line);
    myLog("($userID)body($len)=$line<\n") if($debug && $debugVerbose);
  }

  if($len!=0) {
    myLog("($userID)** len=$len line=$line\n");
  }
  close($socket);
}
 
sub httpGet {
  my ($url)=@_;
  httpConnect();
  my $data= "GET $url HTTP/1.1\015\012";
  $data.="Host: $CGServerAddress:$CGServerWebmailPort\015\012";
  $data.="\015\012";
  myLog("($userID)>$data") if($debug);
  sendCommand($data);
  httpReadResponse();
}

sub httpPost {
  my ($url,$postData,$separator)=@_;
  httpConnect();
  my $data= "POST $url HTTP/1.1\015\012";
  $data.="Host: $CGServerAddress:$CGServerWebmailPort\015\012";
  $data.="Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5\015\012";
#  $data.="Accept-Language: en-us,en;q=0.5\015\012";
  $data.="Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\015\012";
#  $data.="Keep-Alive: 300\015\012";
#  $data.="Connection: keep-alive\015\012";
#  $data.="Referer: http://$CGServerAddress:$CGServerWebmailPort/Session/$sessionID/Compose.wssp\015\012";

  $data.="Content-Type: multipart/form-data; boundary=$separator\015\012";
  $data.="Content-Length: ".(length($postData))."\015\012\015\012";
  myLog("($userID)>$data") if($debug);
  
  $data.="$postData";
  myLog("($userID)>$postData") if($debug && $debugVerbose);
  sendCommand($data);
  httpReadResponse();
}

#========================================================

sub webmailGetPage {
  my ($page)=@_;
  httpGet("/Session/$sessionID/$page");
  if($httpRetCode ne 200) {
    die "Getting $page failed: $httpRetText\n";
  }  
}

sub submitMessage {
  my ($toAddress,$subject,$msgSize) =@_;

  my $messageText="This is a test message\n\n";
  my $attachmentText="This is a test attachment\n\n";
  
  my $line=("a"x63)."\n";
  my $oneKText="$line"x16;
  
  my $attachmentSize=$msgSize/2;
  my $textSize=$msgSize-$attachmentSize;
  for(;$attachmentSize>0;$attachmentSize--) {
    $attachmentText.=$oneKText;
  }
  for(;$textSize>0;$textSize--) {
    $messageText.=$oneKText;
  }
  
  my $separator='---------------------------12345'.rand();
  my $msgBody=<<EOT;
--$separator
Content-Disposition: form-data; name="Send"

Send
--$separator
Content-Disposition: form-data; name="FormCharset"

utf-8
--$separator
Content-Disposition: form-data; name="filled"

1
--$separator
Content-Disposition: form-data; name="selectedAddressBook"

(My Domain)
--$separator
Content-Disposition: form-data; name="To"

$toAddress
--$separator
Content-Disposition: form-data; name="Subject"

$subject
--$separator
Content-Disposition: form-data; name="Cc"


--$separator
Content-Disposition: form-data; name="Bcc"


--$separator
Content-Disposition: form-data; name="desiredCharset"

utf-8
--$separator
Content-Disposition: form-data; name="Body"

$messageText
--$separator
Content-Disposition: form-data; name="Attachment"; filename="attachment.txt"
Content-Type: text/plain

$attachmentText
--$separator
Content-Disposition: form-data; name="Attachment"; filename=""
Content-Type: application/octet-stream


--$separator
Content-Disposition: form-data; name="SaveSent"

1
--$separator
Content-Disposition: form-data; name="DSN"

0
--$separator
Content-Disposition: form-data; name="MDN"

1
--$separator
Content-Disposition: form-data; name="Priority"

0
--$separator--

EOT

  $msgBody=~s/\r//g;
  $msgBody=~s/\n/\015\012/g;
  
  httpPost("/Session/$sessionID/compose.wssp",$msgBody,$separator);
  if($httpRetCode eq 301) {
    my $newLoc=$httpHeader{Location};
    $newLoc=~/(\/Session\/.*)$/;
    $newLoc=$1;
    httpGet($newLoc);
  } else {
    #die "unexpected answer: $httpRetText\n";
  }

}


sub webmailLogin {
  my ($username,$password)=@_;
  httpGet("/?username=$username&password=$password");

  if($httpRetCode eq 301) {
    my $newLoc=$httpHeader{Location};
    $newLoc=~/Session\/(.*)?\//;
    $sessionID=$1;
    myLog("($userID) SessionID=$sessionID\n");
    $newLoc=~/(\/Session\/.*)$/;
    $newLoc=$1;
    httpGet($newLoc);
  } else {
    die "unexpected answer: $httpRetText\n";
  }
   
}

sub webmailLogin2 {
  my ($username,$password)=@_;
 my $separator='---------------------------123'.rand();
  
  my $msgBody=<<EOT;
--$separator
Content-Disposition: form-data; name="FormCharset"

iso-8859-1
--$separator
Content-Disposition: form-data; name="Username"

$username
--$separator
Content-Disposition: form-data; name="Password"

$password
--$separator
Content-Disposition: form-data; name="SessionSkin"


--$separator
Content-Disposition: form-data; name="DisableIPWatch"

on
--$separator
Content-Disposition: form-data; name="DisableUseCookie"

on
--$separator
Content-Disposition: form-data; name="login"

Enter
--$separator
Content-Disposition: form-data; name="Skin"


--$separator--
EOT

  #";
  $msgBody=~s/\r//g;
  $msgBody=~s/\n/\015\012/g;
  httpPost("/",$msgBody,$separator);
     
}

sub webmailOpenMailbox {
  my $mailboxName=$_[0];
  webmailGetPage("mailbox.wssp?mailbox=$mailboxName&");
}

sub webmailReadMailbox {
  my $mailboxName=$_[0];
  webmailGetPage("mailbox.wssp?mailbox=$mailboxName&");

  my %msgIDs;
  foreach(@httpBody) {
    if(/<a href=\"Message.wssp\?Mailbox=INBOX&MSG=(\d+)\"/) { #"
      $msgIDs{$1}=1;
    }
  }
  foreach(sort keys %msgIDs) {
   #print "message ID=$_\n";
    webmailGetPage("Message.wssp?Mailbox=$mailboxName&MSG=$_");
  }

}


__END__
