#!/usr/bin/perl
#
#  This is a sample CGI program that displays a form where
#  you should specify the sub-domain name and postmaster
#  password. After you click "Create" button
#  it will connect to CGPro and create the domain
#  with the postmaster account.
#
#  Don't run it from the command shell if you don't know what you're doing.
#
#  The CGPro's address and the main domain Postmaster login params
#  should be defined manually in the script's text, see below.
#
#

my $CGServerAddress = "127.0.0.1";
my $MainPostmasterLogin = "Postmaster";
my $MainPostmasterPassword = "";

BEGIN
{
 use FindBin qw($Bin);
 use lib "$Bin";
}#This is for web server so it could find CLI.pm from the current directory 

use strict;
use CLI;
use CGI qw(:standard);

print header;               # Print "Context-type: text/html"

# print "<HTML>"
# print "<HEAD>Domain Creation Sample CGI</HEAD>"
# print "<BODY>"
print start_html("Domain Creation Sample CGI");

if($MainPostmasterPassword eq "") {         # You didn't specify domain/login/password

  errormsg("You have to modify the script file to specify the CGPro Server address and Main Domain Postmaster password");

} elsif(param()) {                      # The form is already filled
  # Read the parameters from the form
  my $Domain = param("domain");
  my $RealName = param("realname");
  my $Password1 = param("password1");
  my $Password2 = param("password2");

  if ($Domain eq "") {
    errormsg("No domain name specified");
  }
  if ($Password1 eq "") {
    errormsg("No password specified");
  }
  if ($Password1 ne $Password2) {
    errormsg("Passwords do not match!");
  }
  my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                            PeerPort => 106,
                            login    => $MainPostmasterLogin,
                            password => $MainPostmasterPassword } );
  unless($cli) {
    errormsg("Can't login to CGPro: ".$CGP::ERR_STRING);
    last MAIN;
  }
  my $MainDomainName=$cli->MainDomainName();

  $Domain.='.'.$MainDomainName;
  unless($cli->CreateDomain($Domain)) {
    errormsg("Can't create '$Domain' domain: ".$cli->getErrMessage);
    last MAIN;
  }
  
  my $UserData;
  @$UserData{'RealName'}=$RealName;
  @$UserData{'Password'}=$Password1;


  unless($cli->CreateAccount(accountName => "postmaster\@$Domain",
                            settings => $UserData)) {
    errormsg("Can't create 'postmaster\@$Domain' account: ".$cli->getErrMessage);
    last MAIN;
  }

  my @Rights=qw(
     Domain AutoSignup TrailerText WebBanner Foldering
     FolderIndex AllWithForwarders MailToAllAction
     MailToUnknown MailRerouteAddress CentralDirectory RelayAddress
     BasicSettings WebUserSettings WebSite MaxAccountSize MaxWebSize
     MaxWebFiles UseAppPassword PWDAllowed RequireAPOP
     PasswordEncryption RulesAllowed RPOPAllowed AccessModes
     MailToAll AddMailTrailer AddWebBanner DefaultMailboxType
     CanCreateAccounts CanCreateGroups CanCreateForwarders
     CanCreateLists CanCreateAliases CanCreateWebPages
     CanPostAlerts CanAccessMailboxes
  );
  if($cli->SetAccountRights("postmaster\@$Domain",\@Rights)) {
                    
    print h1("Domain created.");
    print a({-href=>'CreateDomainCGI.pl'},
                                      'Register one more domain<br>');
    print a({-href=>"http://$MainDomainName:8010/Admin/$Domain/"},
                                      'Open the created domain admin interface');

  } else {
    errormsg("Can't set the postmaster account rights: ".$cli->getErrMessage);
    last MAIN;
  }

  $cli->Logout;

} else {
  
  my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                            PeerPort => 106,
                            login    => $MainPostmasterLogin,
                            password => $MainPostmasterPassword } );
  unless($cli) {
    errormsg("Can't login to CGPro: ".$CGP::ERR_STRING);
    last MAIN;
  }
  my $MainDomainName=$cli->MainDomainName();
  $cli->Logout;
   
                           # The form is empty
  print h1("Register a Domain: "),hr();
  print start_form();
  print p("Domain name: ",textfield("domain"),"<b>.$MainDomainName</b>");
  print p("Postmaster's real name: ",textfield("realname"));
  print p("Postmaster's password: ",password_field("password1"));
  print p("Postmaster's Password (again): ",password_field("password2"));

  print p(submit("Create"),reset("Clear"));
  print end_form(),hr();
}
print end_html();  # print"</BODY></HTML>"

sub errormsg {  #a procedure to output error message in HTML format and exit
 my ($msg) = @_;
 print h1("ERROR: $msg");
 print a({-href=>'CreateDomainCGI.pl'}, 'Register a Domain');
 print end_html();
 exit;
}
