#!/usr/bin/perl -w
#
#  A simple script for analysing CommuniGatePro supplementary Email logs.
#  Prints out incoming and outgoing traffic details. 
#
#  Please send your comments and suggestions to <support@communigatepro.ru>
#
#  Revision date: 14-Nov-2019

use strict;

if(@ARGV eq 0) {
  print "Usage: ./EmailLogAnalyse.pl log_file [log_file ...]\n";
  exit;
}


my (%OutList,%ErrorList);

while(<>) {
  next unless(/^\d/);

  my($time,$stat,$retPath,$from,$auth,$submit,$localIP,$id,$msgID,$size,$rcpt,$module,$report)=split('\t');
  
  my $list=($stat eq 'ERROR') ? \%ErrorList : \%OutList;
  
  my $src=$auth || $from || $retPath;
  $src=$1 if($src=~/\<(.*)\>/);
  $src=lc($src); 
  AddToOutput($list,$src,$size) if(isDesired($src));

  $rcpt=$1 if($rcpt=~/\<(.*)\>/);
  $rcpt=lc($rcpt); 
  AddToInput($list,$rcpt,$size) if(isDesired($rcpt));
  
}


printList(\%OutList,"Per Account Traffic"); 
printList(\%ErrorList,"Errors Traffic");

exit(0);




sub isDesired {
  my $addr= $_[0];

  return 1;  #remove this line for the filtered output

  if($addr =~/\@/) {
    return 1 if($addr =~/\@mydomain\.com/);  # insert your domain here
    return 0;  
  }
  return 0 if($addr =~/[\[\]\s]/);  # IP address or 'Dequeuer Report'
  return 1;  #or 0 if you don't want mails for the main domain to be counted
}

sub AddToOutput {
  my ($listRef,$source,$size)= @_;
  my ($mailsIn,$bytesIn,$mailsOut,$bytesOut);
  if(defined $listRef->{$source}) {
    my $data=$listRef->{$source};
    ($mailsIn,$bytesIn,$mailsOut,$bytesOut)=@$data;
  } else {
    $mailsIn=$bytesIn=$mailsOut=$bytesOut=0;
  }
  ++$mailsOut; $bytesOut+=$size;
  $listRef->{$source}= [$mailsIn,$bytesIn,$mailsOut,$bytesOut];
}

sub AddToInput {
  my ($listRef,$dest,$size)= @_;
  my ($mailsIn,$bytesIn,$mailsOut,$bytesOut);
  if(defined $listRef->{$dest}) {
    my $data=$listRef->{$dest};
    ($mailsIn,$bytesIn,$mailsOut,$bytesOut)=@$data;
  } else {
    $mailsIn=$bytesIn=$mailsOut=$bytesOut=0;
  }
  ++$mailsIn; $bytesIn+=$size;
  $listRef->{$dest}= [$mailsIn,$bytesIn,$mailsOut,$bytesOut];
}

sub printList {
  my ($listRef,$title)=@_;
  my ($totalMailsIn,$totalBytesIn,$totalMailsOut,$totalBytesOut)=(0,0,0,0);
my ($id,$mailsIn,$bytesIn,$mailsOut,$bytesOut);
format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>> @>>>>>> @>>>> @>>>>>>
$id,$mailsIn,$bytesIn,$mailsOut,$bytesOut
.

# This will be displayed on the top of the each output page.
format STDOUT_TOP =
                                                 Mails         Mails
Address                                             In   Bytes   Out   Bytes
================================================ ===== ======= ===== =======
.

  print "\n$title:\n";
  foreach $id (sort keys %$listRef) {
    my $data=$listRef->{$id};
    ($mailsIn,$bytesIn,$mailsOut,$bytesOut)=@$data;
    write;
    $totalMailsIn+=$mailsIn; $totalMailsOut+=$mailsOut;
    $totalBytesIn+=$bytesIn; $totalBytesOut+=$bytesOut;

  }
  print '-' x 76 ."\n";
  $id="Total:";
  $mailsIn=$totalMailsIn;$bytesIn=$totalBytesIn;
  $mailsOut=$totalMailsOut;$bytesOut=$totalBytesOut;
  write;  
  
}

