#!/usr/bin/perl -w

##############################################################################
#  This sample script displays the list of users and some of their settings
#  from the specified domain.
#
#  You'll be prompted for the domain name (make sure you can telnet that domain),
#  your user name (enter empty string for "Postmaster") and password. Later you
#  may remove the keyboard input and hard-code them to not to type them each time.
##############################################################################
use strict;

# Make sure the "CLI.pm" is in current directory
use CLI;

my ($userName,$realName,$maxSize,$storageUsed,$lastAccess);
# This is a template for STDOUT output for 'write' call. 
# It specifies the field widths and variables for output. 
# << means left-adjusted, >> is right-adjusted, || is center-adjusted.
# Use "man perlform" for more info.
format STDOUT =
@<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<< @>>>>>> @>>>>>>>>> @<<<<<<<<<<<<<<<<<<<<<
$userName,    $realName,  $maxSize,$storageUsed, $lastAccess
.

# This will be displayed on the top of the each output page.
format STDOUT_TOP =
                                      Max     Storage    Last
Account     Real Name                 Size    Used       Login
=========== ========================= ======= ========== ======================
.



print "Server address: "; 	# Print the server name prompt
my $CGServerAddress = <STDIN>;  # Read the domain name from standard input
chomp $CGServerAddress;        # Remove \n if present

print "Domain: ";         # Print the domain prompt
my $Domain = <STDIN>;     # Read the domain name from standard input
chomp $Domain;            # Remove \n if present

print "Login (Enter for \"postmaster\"): ";
my $Login = <STDIN>;
chomp $Login;
if ($Login eq '') { $Login = "postmaster"; }

print "Password: ";
my $Password = <STDIN>;
chomp $Password;

# Open TCP connection to given address port 106 (PWD, or CGPro CLI).
# Submit username and password. If login fail, the program will stop.
my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => 106,
                          login    => $Login,
                          password => $Password } )
   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";


# Read the list of accounts.
# The list is a hash with key="user name" and value="mailbox type".
my $accountList = $cli->ListAccounts($Domain);

# If the list is empty, stop with the error message. 
die "\nError " . $cli->getErrMessage . "(".$cli->getErrCode.
    ") fetching accounts list\n"
    unless ($accountList);

my $count = 0;        # Declare & reset the number-of-accounts counter.

# Sort the list by keys (user names) and process each list entry  
foreach $userName (sort keys %$accountList) {

  # Get the list of account parameters. The list is a hash,
  # the key is a parameter name and value is the parameter's value.
  my $accountData = $cli->GetAccountEffectiveSettings("$userName\@$Domain");
  # You may wish to add here 'die unless ($accountData);', but it's not
  # necessary to stop the entire program due to one user read failure.
  
  $realName = @$accountData{'RealName'} || '';
  $maxSize = @$accountData{'MaxAccountSize'} || '';

  #get additional information about the account
  $storageUsed=$cli->GetAccountInfo("$userName\@$Domain",'StorageUsed') || '-empty-';
  $lastAccess=$cli->GetAccountInfo("$userName\@$Domain",'LastLogin') || '-not yet-';

  write;             # Output the variables using the format defined above.
  ++$count;          # Increase the number of accounts counter
}

print "\nTotal: $count\n";   # Print the total number of users listed.
$cli->Logout;                 # Close the CLI session and disconnect 

__END__

