#!/usr/bin/perl -w

##############################################################################
#  This sample script displays the number of accounts, groups, forwarders and
#  mailing lists in each of your CommuniGate Pro domains, and their total
#  number for all domains.
#
#  You'll be prompted for the CGPro main domain name (make sure you can telnet
#  that domain) and postmaster password.
##############################################################################

# Make sure the "CLI.pm" is in current directory
use CLI;

# This is a template for STDOUT output for 'write' call. 
# It specifies the field widths and variables for output. 
# << means left-adjusted, >> is right-adjusted, || is center-adjusted.
# Use "man perlform" for more info.
format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>>>>> @>>>>>>>> @>>>>>>>>> @>>>>>>>
$domainName,                         $nAccounts, $nGroups, $nForwarders, $nLists
.

# This will be displayed on the top of the each output page.
format STDOUT_TOP =
                                   
Domain                               Accounts    Groups Forwarders    Lists
=================================== ========= ========= ========== ========
.



print "Server address: "; 	# Print the server name prompt
my $CGServerAddress = <STDIN>;  # Read the domain name from standard input
chomp $CGServerAddress;        # Remove \n if present

print "Postmaster Password: ";
my $Password = <STDIN>;
chomp $Password;

# Open TCP connection to given address port 106 (PWD, or CGPro CLI).
# Submit username and password. If login fail, the program will stop.
my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => 106,
                          login    => "postmaster",
                          password => $Password } )
   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";


my ($tAccounts,$tGroups,$tForwarders,$tLists);

my $domList=$cli->ListDomains() || die "can't list domains";
foreach $domainName (sort @$domList) {            
  my $accList=$cli->ListAccounts($domainName)
     || die "\nError: " . $cli->getErrMessage . "(".$cli->getErrCode.
        ") fetching list of accounts for $domainName\n";
  $nAccounts=(keys %$accList);
  
  my $groupList=$cli->ListGroups($domainName)
     || die "\nError: " . $cli->getErrMessage . "(".$cli->getErrCode.
        ") fetching list of groups for $domainName\n";
  $nGroups=@$groupList;

  my $forwList=$cli->ListForwarders($domainName)
     || die "\nError: " . $cli->getErrMessage . "(".$cli->getErrCode.
        ") fetching list of forwarders for $domainName\n";
  $nForwarders=@$forwList;

  if(my $listsList=$cli->ListLists($domainName)) {
    $nLists=@$listsList;
  } else {
    ($cli->isSuccess) ? $nLists=0 :
       die "\nError: " . $cli->getErrMessage . "(".$cli->getErrCode.
       ") fetching list of mailing lists for $domainName\n";
  }
  write;                       # Output the variables using the format defined above.

  $tAccounts+=$nAccounts;      # Add to totals
  $tGroups+=$nGroups;
  $tForwarders+=$nForwarders;
  $tLists+=$nLists;

}

print "=================================== ========= ========= ========== ========\n";
$domainName='Total'; $nAccounts=$tAccounts; $nGroups=$tGroups;
$nForwarders=$tForwarders; $nLists=$tLists;
write;                         # Write the totals


$cli->Logout                   # Close the CLI session and disconnect 

__END__ 
