#!/usr/bin/perl -w

#

# This sript will register all your Unix users in CGPro.

# The user list will be read from /etc/passwd file.

# This script obviously won't work on Win9X/NT.

#



use CLI;



my $UserData = {

  UseSysPassword => 'Yes',

  UseAppPassword => 'No',

  AccessModes =>  [ qw(Mail POP IMAP PWD WebMail WebSite) ],

  MaxAccountSize =>  '100K',

};



my @ForbiddenNames = qw(root ftp mail news uucp);



# Open UNIX passwords file.

open(PASSW,"/etc/passwd") || die "Can't open /etc/passwd: $!\n";



print "Domain: ";         # Print the domain prompt

my $Domain = <STDIN>;     # Read the domain name from standard input

chomp $Domain;            # Remove \n if present



# You may need to redefine the following variable if you're connecting not to

# the main domain. IP address is OK.

$CGServerAddress = $Domain;



print "Login (Enter for \"Postmaster\@$Domain\"): ";

my $Login = <STDIN>;

chomp $Login;

if ($Login eq '') { $Login = "Postmaster\@$Domain"; }



print "Password: ";

my $Password = <STDIN>;

chomp $Password;



# Open TCP connection to given address port 106 (PWD, or CGPro CLI).

# Submit username and password. If login fail, the program will stop.

my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,

                          PeerPort => 106,

                          login    => $Login,

                          password => $Password } )

   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";





READ: while(<PASSW>) {    # Read string into $_ while the file is not empty

  #the $_ now look like "user::25:10:Real Name:/home/user:"

  my ($UserName,$RealName) = (split(/:/))[0,4]; #get 1st and 5th elements from $_



  #print $UserName," ",$RealName, "\n";



  foreach (@ForbiddenNames) {

    if($_ eq $UserName) {

      print "Skipping $UserName ($RealName)\n";

      next READ;    # Go to READ label / contingue the while loop.

    }

  }



  @$UserData{'RealName'} = $RealName;  # Add RealName to user data

  if($cli->CreateAccount( accountName => "$UserName\@$Domain",                            

                             settings => $UserData,  )) {

    print "\"$UserName\@$Domain\" ($RealName) created.\n";

  } else {

    print "Unable to create \"$UserName\@$Domain\": ".$cli->getErrMessage."\n";

  }



}

$cli->Logout;

close(PASSW) || die "Can't close /etc/passwd: $!\n";

