#!/usr/bin/perl -w

#  A sample external authentication script for CommuniGate Pro.
#  This script checks the strength of the password being entered.
#  To work fully it requires CommuniGate 5.3.5 or later.
#
#   
#  Original homepage:
#  <http://communigatepro.ru/CGAUTH>
#
#  Related links:
#  <http://communigatepro.ru/CommuniGatePro/Helpers.html#AUTH>
#  <http://communigatepro.ru/CommuniGatePro/Security.html#External>
#  <http://communigatepro.ru/CommuniGatePro/Domains.html#Provision>
#
#  Mail your comments and suggestions to <support@communigatepro.ru>
#

use strict;
use Text::ParseWords;

my $minPasswordLength=6;

my $errTooShort="password is too short";
my $errTooSimple="password is too simple";

#  The above error messages can be customized through "ErrorCodes" dictionary
#  in "strings.data" file. Example:
#    ErrorCodes	= {
#	"password is too short" = "The password is too short, it must be at least 6 characters long";
#   };
#




$| = 1; 


print "* authProvision.pl started\n";    
while(<STDIN>) {
  chomp;
  next if($_ eq '');
  my ($prefix,$command,$arg1,$arg2,$arg3) = parse_line('\s+', 0, $_);

  if($command eq 'INTF') {
    print "$prefix INTF 10\n";

  } elsif($command eq 'QUIT') {
    print "$prefix OK\n";
    last;

  } elsif($command eq 'PRECREATE') {
    my $settings=$arg3;
    print "* s=$settings\n";
    print "$prefix OK\n";

  } elsif($command eq 'POSTCREATE') {

    print "$prefix OK\n";

  } elsif($command eq 'PRERENAME') {

    print "$prefix OK\n";

  } elsif($command eq 'POSTRENAME') {

    print "$prefix OK\n";

  } elsif($command eq 'PREDELETE') {

    print "$prefix OK\n";

  } elsif($command eq 'POSTDELETE') {

    print "$prefix OK\n";

  } elsif($command eq 'PRETYPECHANGE') {

    print "$prefix OK\n";

  } elsif($command eq 'POSTTYPECHANGE') {

    print "$prefix OK\n";

  } elsif($command eq 'PREUPDATE') {

    print "$prefix OK\n";

  } elsif($command eq 'POSTUPDATE') {

    print "$prefix OK\n";

  } elsif($command eq 'PREPWDCHANGE') {
    my $errCode=checkPassword($arg1,$arg2);
    if($errCode) {
      print "$prefix FAILURE \"$errCode\"\n";
    } else {
      print "$prefix OK\n";
    }

  } else {
    print "$prefix FAILURE \"unexpected command: $command\"\n";

  }
}
print "* authProvision.pl stopped\n";    
exit(0);


sub checkPassword {
  my ($account,$password)=@_;
  return $errTooShort if(length($password)<$minPasswordLength);
  return $errTooSimple if($account=~/\Q$password\E/i); # password must not be similar to account name
  return $errTooSimple unless($password=~/\d/);    # must contain at least 1 digit
  return $errTooSimple unless($password=~/[A-Z]/ && $password=~/[a-z]/); # must contain upper and lower case letters
  undef;
}




__END__

