#!/usr/bin/perl -w
#
# unsubscribeUsers.pl
#
# Searches the users' mailbox aliases and subscription lists for specified pattern
# and optionally deletes those subscriptions.

# Usage: ./unsubscribeUsers.pl [-delete] pattern
# the pattern is Perl regular expression, but without ^ and $.
#
# Examples:
#   ./unsubscribeUsers.pl ~public/.*
#  See who is subscribed to 'public' account shared mailboxes
#   
#   ./unsubscribeUsers.pl -delete .*/INBOX
#  Unsubscribe from everyone's shared INBOXes.
#  
# Please mail your comments and suggestions to <support@communigatepro.ru>


use CLI;  # get one from communigatepro.ru/CGPerl
use strict;


######  You should redefine some of these values !!!

my $CGServerAddress = "127.0.0.1";   
my $Login = "Postmaster";
my $Password = "pass";

#### end of the customizeable variables list

my $pattern;
my $mode='';

if(@ARGV==2) {
  if($ARGV[0] eq '-delete') {
    $mode='del';
    shift(@ARGV);
  }  
}
if(@ARGV != 1) {
  print "Usage: ./unsubscribeUsers.pl [-delete] pattern\n";
  exit 1;
}
$pattern=$ARGV[0];
print "Searching subscriptions for '$pattern'\n";

my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => 106,
                          login    => $Login,
                          password => $Password } )
   || die "*** Can't login to CGPro CLI: ".$CGP::ERR_STRING."\n";

processAllDomains();
#processDomain('company.com');
#processAccount('user@company.com');


$cli->Logout();
print "Done\n";
exit;


sub processAllDomains {
  my $DomainList = $cli->ListDomains()
               || die "*** Can't get the domain list: ".$cli->getErrMessage.", quitting";
  foreach(@$DomainList) {
    processDomain($_);
  }
}         


sub processDomain {
  my $domain=$_[0];
#  print "Domain: $domain\n";

  my $cookie="";
  do {
    my $data=$cli->ListDomainObjects($domain,5000,undef,'ACCOUNTS',$cookie);
    unless($data) {
      print "*** Can't get accounts for $domain: ".$cli->getErrMessage."\n";
      return;
    }
    $cookie=$data->[4];
    foreach(keys %{$data->[1]} ) {
      processAccount("$_\@$domain"); 
    }
  }while($cookie ne '');
 
}



sub processAccount {
  my ($account)=@_;
#  print "Account: $accountn";

  my $data=$cli->GetMailboxAliases($account);
  unless($data) {
    print "*** Can't get aliases for $account: ".$cli->getErrMessage."\n";
    return;
  }
  my $found=0;
  foreach(keys %$data) {
    my $tgt=$data->{$_};
    if($tgt=~/^$pattern$/) {
      print " $account: alias ($_)->($tgt)\n";
      $found=1;
      delete($data->{$_});
    }
  }
  if($found && $mode eq 'del') {  
    unless($cli->SetMailboxAliases($account,$data)) {
      print "*** Can't set aliases for $account: ".$cli->getErrMessage."\n";
    }
  }
  
  $data=$cli->GetMailboxSubscription($account);
  unless($data) {
    print "*** Can't get subscription for $account: ".$cli->getErrMessage."\n";
    return;
  }
  $found=0;
  for(my $idx=0;$idx<scalar(@$data);$idx++ ) {
    if($data->[$idx] =~ /^$pattern$/) {
      print " $account: subscription ($data->[$idx])\n";
      $found=1;
      splice(@$data,$idx--,1);
    }
  }
  if($found && $mode eq 'del') {  
    unless($cli->SetMailboxSubscription($account,$data)) {
      print "*** Can't set subscription for $account: ".$cli->getErrMessage."\n";
    }
  }  

    
}

__END__


