#!/usr/bin/perl -w

#
#  This script changes the domain part of the "From:" addresses
#  of WebMail & Pronto users in a given domain to another value.
#

use CLI; #get one from communigatepro.ru/CGPerl/

#### you should redefine these values.

my $CGServerAddress='127.0.0.1';  #IP or domain name;
my $Login='postmaster';
my $Password='pass';

my $Domain='mail.company.com'; # where the accounts are
my $destDomain = 'company.com';

#### end of the customizeable variables list


my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => 106,
                          login    => $Login,
                          password => $Password } )
   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";

my $count=0;
my $accountsList = $cli->ListAccounts($Domain)
  || die "Can't list accounts for $Domain: " . $cli->getErrMessage;

foreach ( sort keys %$accountsList ) {
  updateFromAddress($_);
}

print "$count accounts updated\n";

$cli->Logout;


sub updateFromAddress {

  my $account = $_;

  my $settings = $cli->GetAccountSettings("$account\@$Domain")
    || die "Can't get settings for $account: " . $cli->getErrMessage;
  my $name = @$settings{RealName};
  
  $name=$account unless(defined $name && $name ne '');
    
  @$webSettings{UserFrom} = "$name <$account\@$destDomain>";
 
  $cli->UpdateAccountPrefs("$account\@$Domain", $webSettings )
    || die "Can't update account prefs for $account: " . $cli->getErrMessage;
  $count++;
}


