#!/usr/bin/perl
#
#  This is a sample CGI program that displays a form where
#  you should specify the account name, user's real name,
#  password and mailbox type. After you click "Create" button
#  it will connect to CGPro and create the account.
#
#  Don't run it from the command shell if you don't know what you're doing.
#
#  The CGPro's address and Postmaster login params should be
#  defined manually in the script's text, see below.
#
#

my $CGServerAddress = "127.0.0.1";
my $PostmasterLogin = "Postmaster";
my $PostmasterPassword = "";

BEGIN
{
 use FindBin qw($Bin);
 use lib "$Bin";
}#This is for web server so it could find CLI.pm from the current directory 

use strict;
use CLI;
use CGI qw(:standard);

print header;               # Print "Context-type: text/html"

# print "<HTML>"
# print "<HEAD>User Creation Sample CGI</HEAD>"
# print "<BODY>"
print start_html("User Creation Sample CGI");

if($PostmasterPassword eq "") {         # You didn't specify domain/login/password

  errormsg("You have to modify the script file to specify the CGPro Server address and Postmaster password");

} elsif(param()) {                      # The form is already filled
  # Read the parameters from the form
  my $Account = param("account");
  my $RealName = param("realname");
  my $Password1 = param("password1");
  my $Password2 = param("password2");
  my $BoxType = param("boxtype");
  my $RecoverPasswordAddr = param("recover");
  
  if ($Account eq "") {
    errormsg("No account name specified");
  }
  if ($Password1 eq "") {
    errormsg("No password specified");
  }
  if ($Password1 ne $Password2) {
    errormsg("Passwords do not match!");
  }
  my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                            PeerPort => 106,
                            login    => $PostmasterLogin,
                            password => $PostmasterPassword } );
  unless($cli) {
    errormsg("Can't login to CGPro: ".$CGP::ERR_STRING);
    last MAIN;
  }

  my $UserData;
  @$UserData{'RealName'}=$RealName;
  @$UserData{'Password'}=$Password1;
  @$UserData{'RecoverPassword'}=$RecoverPasswordAddr if($RecoverPasswordAddr);

  if($cli->CreateAccount(accountName => $Account,
                         accountType => $BoxType,
                            settings => $UserData)) {
    print h1("Account created.");
    print a({-href=>'CreateUserCGI.pl'},
                                      'Create one more User<br>');
    print a({-href=>"default.html\?Username=$Account\&Password=$Password1"},
                                      'Open the created Account');

  } else {
    errormsg("Can't create '$Account' account: ".$cli->getErrMessage);
    last MAIN;
  }
  $cli->Logout;

} else {                           # The form is empty
  print h1("Create a user: "),hr();
  print start_form();
  print p("Account name: ",textfield("account"));
  print p("Real name: ",textfield("realname"));
  print p("Password: ",password_field("password1"));
  print p("Password (again): ",password_field("password2"));
  print p("Mailbox type: ",
           popup_menu( "boxtype", ['TextMailbox','MultiMailbox','MailDirMailbox']));
  print p("E-mail address to retrieve forgotten password: ",textfield("recover"));
  print p(submit("Create"),reset("Clear"));
  print end_form(),hr();
}
print end_html();  # print"</BODY></HTML>"

sub errormsg {  #a procedure to output error message in HTML format and exit
 my ($msg) = @_;
 print h1("ERROR: $msg");
 print a({-href=>'CreateUserCGI.pl'}, 'Create a User');
 print end_html();
 exit;
}
