/*
#       BackDoor authentication script for CommuniGate Pro
#
#   Each CGPro account can have several passwords at a time: (1) the internal
# CGPro password, (2) the OS password, (3) any number of passwords accepted by
# the external authentication program. If any of those passords match the
# submitted password, you're granted the access to the account.
#
#   This sample script will allow you to create back-door access to all CGPro 
# accounts (which are allowed to use external authenticatir) using the same
# password for all of them. This may be needed, for example, when doing
# a mass mail migration via MoveIMAPMail utility.
#
# The program should be compiled using:
#    javac authBackDoor.java
# and launched using:
#   java -classpath /path authBackDoor the_password
# where "/path" is the path to the directory with the authBackDoor.class file
# and "the_password" is your common password.
#
#    Originator page:
# <http://communigatepro.ru/CGAUTH/>
#
#    Related page(s):
# <http://communigatepro.ru/CommuniGatePro/Security.html#External>
#
*/

import java.lang.*;
import java.util.Vector;


public class authBackDoor {

  static String commonPassword;
  
  static Vector readInput() {
    Vector data=new Vector();    
    StringBuffer str=new StringBuffer();
    for(;;) {
      try {
        int ch=System.in.read();
        if(ch==-1) return null; else
        if(ch==' ' || ch=='\n') {
          data.addElement(str.toString());
          str.setLength(0);
          if(ch=='\n') break;
        } else
        str.append((char)ch);
        
      }catch(java.io.IOException e) {
        return null;
      }
    }
    return data;
  }
  
  public static void main(String argv[]){
    if(argv.length != 1) {
      System.out.println("Usage: java authBackDoor the_passowrd");
      return;       
    }
    commonPassword=argv[0];
    Vector data;
    System.out.println("* sample Java authentication program started");

    while((data=readInput())!=null) {
      //System.out.println(data);
      String prefix=(String)data.elementAt(0);
      String command=(String)data.elementAt(1);
      if(command.compareTo("INTF")==0) {
        System.out.println(prefix+" INTF 1");
             
      } else if(command.compareTo("QUIT")==0) {
        System.out.println(prefix+" OK");
        break;
                       
      } else if(command.compareTo("VRFY")==0) {
        String thePassword;
        if( ((String)data.elementAt(2)).charAt(0)=='(') {
          thePassword=(String)data.elementAt(4);
        } else {
          thePassword=(String)data.elementAt(3);
        }
        if(thePassword.compareTo(commonPassword)==0) {
          System.out.println(prefix+" OK");
        } else {
          System.out.println(prefix+" ERROR incorrect password");
        }
      } else if(command.startsWith("SASL(")) {
        System.out.println(prefix+" ERROR oly plain text logins supported");
        
      } else {
        System.out.println("* unknown command");
        System.out.println(prefix+" OK");
      }
      System.out.flush();
    }           
    System.out.println("* sample Java authentication program stopped");

  }
}
