#!/usr/bin/perl -w
#
#       BackDoor authentication script for CommuniGate Pro
#
#   Each CGPro account can have several passwords at a time: (1) the internal
# CGPro password, (2) the OS password, (3) any number of passwords accepted by
# the external authentication program. If any of those passords match the
# submitted password, you're granted the access to the account.
#
#   This sample script will allow you to create back-door access to all CGPro 
# accounts (which are allowed to use external authenticatir) using the same
# password for all of them. This may be needed, for example, when doing
# a mass mail migration via MoveIMAPMail utility.
#
#    Originator page:
# <http://communigatepro.ru/CGAUTH>
#
#    Related page(s):
# <http://communigatepro.ru/CommuniGatePro/Security.html#External>
#

use Text::ParseWords;

unless(defined $ARGV[0]) {
  print "Usage: authBackDoor.pl the_password\n";
  exit(1);
}
my $commonPassword=$ARGV[0];

# if you don't like the passowrd to be entered from command line,
# remove the above 5 lines and un-commend the below line. 

#my $commonPassword='the-secret-passowrd';  




$| = 1;
while(<STDIN>) {
  chomp;             
  my ($prefix,$command,$arg1,$arg2,$arg3) = parse_line('\s+', 0, $_);

  if($command eq 'INTF') {
    print "$prefix OK 1\n";
    
  } elsif($command eq 'VRFY') {
    my ($name,$password);
    if($arg1 =~ /^\(.*\)$/) {
      $name=$arg2; $password=$arg3;  
    } else {
      $name=$arg1; $password=$arg2;
    }
        
    unless($name && $password) {  
      print "$prefix ERROR Expected: nnn VRFY user\@domain password\n";

    } else {
      if($password eq $commonPassword) {
       print "$prefix OK\n";   
      } else {
        print "$prefix ERROR incorrect password\n";
      }
    
    }

  } else {
    print "$prefix ERROR unexpected command: $command\n";

  }
}
exit(0);

