#!/usr/bin/perl -w

# Prints out accounts with non-empty "Class of Service" value
#
# Please mail your comments and suggestions to <support@communigatepro.ru>

####  YOU SHOLD REDEFINE THESE VARIABLES !!!

my $CGServerAddress='127.0.0.1';  #IP or domain name;
my $Login='postmaster';
my $Password='pass';

#### end of the customizeable variables list


use CLI;  #get one from communigatepro.ru/CGPerl/
use strict;



my $cli = new CGP::CLI( { PeerAddr => $CGServerAddress,
                          PeerPort => 106,
                          login    => $Login,
                          password => $Password } )
   || die "Can't login to CGPro: ".$CGP::ERR_STRING."\n";


processAllDomains();
#processDomain('company.com');
#processAccount('user@company.com');


$cli->Logout();

exit;


sub processAllDomains {
  my $DomainList = $cli->ListDomains()
               || die "*** Can't get the domain list: ".$cli->getErrMessage.", quitting";
  foreach(@$DomainList) {
    processDomain($_);
  }
}         


sub processDomain {
  my $domain=$_[0];
#  print "Domain: $domain\n";

  my $cookie="";
  do {
    my $data=$cli->ListDomainObjects($domain,5000,undef,'ACCOUNTS',$cookie);
    unless($data) {
      print "*** Can't get accounts for $domain: ".$cli->getErrMessage."\n";
      return;
    }
    $cookie=$data->[4];
    foreach(keys %{$data->[1]} ) {
      processAccount("$_\@$domain"); 
    }
  }while($cookie ne '');
 
}



sub processAccount {
  my ($account)=@_;
  my $data=$cli->GetAccountSettings($account);
    unless($data) {
      print "*** Can't get settings for $account: ".$cli->getErrMessage."\n";
      return;
    }
  if($data->{ServiceClass}) {
    print "$account\t$data->{ServiceClass}\n";
  }
}


__END__

